% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program DOGConvolution.m
[M,  map] = imread('Church.jpg',  'jpeg');   
M1 = rgb2gray(M);
Sz = size(M1);

% Construct a DOG image
[x,  y] = meshgrid(-32:31,  32:-1:-31);
s1 = 4;    % standard deviation of the Gaussian center
s2 = 16;   % standard deviation of the Gaussian surround 
DOGmask = exp(-(x.^2 + y.^2)/2/s1^2) - ...
          (s1/s2)^2*exp(-(x.^2 + y.^2)/2/s2^2);

%Convolve M1 with the DOG image
M2 = conv2(double(M1),  DOGmask);
showImage(uint8(127 + 126*DOGmask),  'grayscale');

% Crop the image to eliminate edge effects
M2 = uint8(M2(17:(Sz(1) + 15),  17:(Sz(2) + 15)));
showImage(M2,   'grayscale');
